<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

/* Here you can insert your functions, filters and actions. */
add_action('elementor_pro/forms/new_record', function ($record, $ajax_handler) {

    $form_name = $record->get_form_settings('form_name');

    if ('jobform' == $form_name) {

        $raw_fields = $record->get('fields');
        $fields = [];
        foreach ($raw_fields as $id => $field) {
            $fields[$id] = $field['value'];
        }

        global $wpdb;
        $output['success'] = $wpdb->insert(
            'application_data',
            array(
                'job_name' => $fields['job_name'],
                'name' => $fields['name'],
                'nationality' => $fields['nationality'],
                'age' => $fields['age'],
                'email' => $fields['email'],
                'phone' => $fields['phone'],
                'address' => $fields['address'],
                'date_of_birth' => $fields['date_of_birth'],
                'gender' => $fields['gender'],
                'highest_qualification' => $fields['highest_qualification'],
                'd_field' => $fields['d_field'],
                'previous_role' => $fields['previous_role'],
                'expertise' => $fields['expertise'],
                'experience' => $fields['experience'],
                'cv_attach' => $fields['cv_attach'],
                'cover_letter' => $fields['cover_letter']
            )
        );

        $ajax_handler->add_response_data(true, $output);
    }
}, 10, 2);

 add_action( 'admin_menu', 'linked_url' );
    function linked_url() {
    add_menu_page( 'linked_url', 'Application Data Submissions', 'read', 'my_slug', '', 'dashicons-text', 1 );
}

add_action( 'admin_menu' , 'linkedurl_function' );
    function linkedurl_function() {
    global $menu;
    $menu[1][2] = "https://site.imatongemploy.com/wp-admin/admin.php?page=e-form-submissions";
}

function custom_menu_page_removing() {
    if ( get_currentuserinfo()->user_email == 'imatong@imatongemploy.com' )
        remove_menu_page( 'edit.php' );
        //('edit.php'); // Posts
   remove_menu_page('upload.php'); // Media
   remove_menu_page('link-manager.php'); // Links
   remove_menu_page('edit-comments.php'); // Comments
   remove_menu_page('edit.php?post_type=page'); // Pages
   remove_menu_page('plugins.php'); // Plugins
   remove_menu_page('themes.php'); // Appearance
   remove_menu_page('users.php'); // Users
   remove_menu_page('tools.php'); // Tools
   remove_menu_page('options-general.php'); // 
   remove_menu_page('revslider'); // Settings
   remove_menu_page('elementskit'); // Settings
   remove_menu_page('skt_template_about'); // Settings
   remove_menu_page('epic'); // Settings
   remove_menu_page('ai1wm_export'); // Settings
   remove_menu_page('loginpress-settings'); // Settings
   
   //Hide "Elementor".
	remove_menu_page('elementor');
	//Hide "Elementor → Home".
	remove_submenu_page('elementor', 'elementor');
	//Hide "Elementor → Settings".
	remove_submenu_page('elementor', 'elementor-settings');
	//Hide "Elementor → Role Manager".
	remove_submenu_page('elementor', 'elementor-role-manager');
	//Hide "Elementor → Element Manager".
	remove_submenu_page('elementor', 'elementor-element-manager');
	//Hide "Elementor → Tools".
	remove_submenu_page('elementor', 'elementor-tools');
	//Hide "Elementor → System Info".
	remove_submenu_page('elementor', 'elementor-system-info');
	//Hide "Elementor → Getting Started".
	remove_submenu_page('elementor', 'elementor-getting-started');
	//Hide "Elementor → Get Help".
	remove_submenu_page('elementor', 'go_knowledge_base_site');
	//Hide "Elementor → Custom Fonts".
	remove_submenu_page('elementor', 'elementor_custom_fonts');
	//Hide "Elementor → Custom Icons".
	remove_submenu_page('elementor', 'elementor_custom_icons');
	//Hide "Elementor → Custom Code".
	remove_submenu_page('elementor', 'elementor_custom_code');
	//Hide "Elementor → Add-ons".
	remove_submenu_page('elementor', 'elementor-apps');
	//Hide "Elementor → Upgrade".
	remove_submenu_page('elementor', 'go_elementor_pro');
	
   //Hide "Templates".
	remove_menu_page('edit.php?post_type=elementor_library');
	//Hide "Templates → Saved Templates".
	remove_submenu_page('edit.php?post_type=elementor_library', 'edit.php?post_type=elementor_library&tabs_group=library');
	//Hide "Templates → Theme Builder".
	remove_submenu_page('edit.php?post_type=elementor_library', 'http://127.0.0.1/wp-admin/admin.php?page=elementor-app&ver=3.21.8#site-editor/promotion');
	

}
// add_action( 'admin_menu', 'custom_menu_page_removing' );

/* That's all, stop editing! Make a great website!. */

/* Init of the framework */

/* This function exist in WP 4.7 and above.
 * Theme has protection from runing it on version below 4.7
 * However, it has to at least run, to give user info about having not compatible WP version :-)
 */
if( function_exists('get_theme_file_path') ){
	/** @noinspection PhpIncludeInspection */
	require_once( get_theme_file_path( '/advance/class-posterity-framework.php' ) );
}
else{
	/** @noinspection PhpIncludeInspection */
	require_once( get_template_directory() . '/advance/class-posterity-framework.php' );
}

global $posterity_a13;
$posterity_a13 = new Posterity_Framework();
$posterity_a13->posterity_start();